<?php

namespace Modules\Finance\Entities;

use Illuminate\Database\Eloquent\Model;

class Fnc_depense extends Model 
{

    protected $table = 'fnc_depenses';
    public $timestamps = true;
    protected $fillable = array('id_enseignant', 'libelle', 'montant', 'date', 'annee_academique', 'nom_table_indexe', 'etat');
    protected $visible = array('id_enseignant', 'libelle', 'montant', 'date', 'annee_academique', 'nom_table_indexe', 'etat');

    public function enseignant()
    {
        return $this->belongsTo('App\Enseignant', 'id_enseignant');
    }

    public function administrateur()
    {
        return $this->belongsTo('App\Administrateur', 'id_enseignant');
    }

}